﻿using System;
using System.Text;

namespace Utf16Example2
{
    class Program
    {
        // Listing 10-84. Prezentacja wartości bajtów zakodowanego tekstu.
        static void Main(string[] args)
        {
            string listenUpFR = "Écoute-moi!";
            
            byte[] utf16Bytes = Encoding.Unicode.GetBytes(listenUpFR);
            // lub...
            // Listing 10-85. Zastosowanie kodowania UTF-16 big-endian
            //byte[] utf16Bytes = Encoding.BigEndianUnicode.GetBytes(listenUpFR);

            Console.WriteLine("UTF-16");
            Console.WriteLine("-----");
            foreach (var encodedByte in utf16Bytes)
            {
                Console.Write(string.Format("{0:X2}", encodedByte));
                Console.Write(" ");
            }
            Console.ReadKey();
        }
    }
}
